package it.eng.eremita.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import io.leangen.graphql.annotations.GraphQLQuery;

@Entity
@Table(name="N2000_TAXON_TASSONOMIA")
public class Specie {

	Long id;
	String denominazioneTaxon;
	String denominazioneCompletaTaxon;	
	String taxGroup;	
	String phylum;	
	String classe;	
	String ordine;	
	String famiglia;	
	String genere;	
	String specie;	
	String sottospecie;	
	String autore;	
	String nomeItaliano;	
	Integer referenzaTassonomica;	
	String nonTaxon;	
	String taxonBuono;	
	String denominazioneTaxonBuono;	
	String sinonimoAccettato;	
	String nomeMenu;
	String note;
	
	
	
	
	@Id
	@Column(name="id")
	@GraphQLQuery(name="id")
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	
	@Column(name="DENOMINAZIONE_TAXON")
	@GraphQLQuery(name="denominazioneTaxon")
	public String getDenominazioneTaxon() {
		return denominazioneTaxon;
	}
	public void setDenominazioneTaxon(String denominazioneTaxon) {
		this.denominazioneTaxon = denominazioneTaxon;
	}
	
	@Column(name="DENOMINAZIONE_COMPLETA_TAXON")
	@GraphQLQuery(name="denominazioneCompletaTaxon")
	public String getDenominazioneCompletaTaxon() {
		return denominazioneCompletaTaxon;
	}
	public void setDenominazioneCompletaTaxon(String denominazioneCompletaTaxon) {
		this.denominazioneCompletaTaxon = denominazioneCompletaTaxon;
	}
	
	@Column(name="TAXGROUP")
	@GraphQLQuery(name="taxgroup")
	public String getTaxGroup() {
		return taxGroup;
	}
	public void setTaxGroup(String taxGroup) {
		this.taxGroup = taxGroup;
	}
	
	
	@Column(name="PHYLUMDIVISIONE")
	@GraphQLQuery(name="phylum")
	public String getPhylum() {
		return phylum;
	}
	public void setPhylum(String phylum) {
		this.phylum = phylum;
	}
	
	@Column(name="CLASSE")

	@GraphQLQuery(name="classe")
	public String getClasse() {
		return classe;
	}
	public void setClasse(String classe) {
		this.classe = classe;
	}
	
	@Column(name="ORDINE")
	@GraphQLQuery(name="ordine")
	public String getOrdine() {
		return ordine;
	}
	public void setOrdine(String ordine) {
		this.ordine = ordine;
	}
	
	@Column(name="FAMIGLIA")
	@GraphQLQuery(name="famiglia")
	public String getFamiglia() {
		return famiglia;
	}
	public void setFamiglia(String famiglia) {
		this.famiglia = famiglia;
	}
	
	@Column(name="GENERE")
	@GraphQLQuery(name="genere")
	public String getGenere() {
		return genere;
	}
	public void setGenere(String genere) {
		this.genere = genere;
	}
	
	@Column(name="SPECIE")
	@GraphQLQuery(name="specie")
	public String getSpecie() {
		return specie;
	}
	public void setSpecie(String specie) {
		this.specie = specie;
	}
	
	@Column(name="SOTTOSPECIE")
	@GraphQLQuery(name="sottospecie")
	public String getSottospecie() {
		return sottospecie;
	}
	public void setSottospecie(String sottospecie) {
		this.sottospecie = sottospecie;
	}
	
	@Column(name="AUTORE")
	@GraphQLQuery(name="autore")
	public String getAutore() {
		return autore;
	}
	public void setAutore(String autore) {
		this.autore = autore;
	}
	
	@Column(name="NOME_ITALIANO")
	@GraphQLQuery(name="nomeItaliano")
	public String getNomeItaliano() {
		return nomeItaliano;
	}
	public void setNomeItaliano(String nomeItaliano) {
		this.nomeItaliano = nomeItaliano;
	}
	
	@Column(name="REFERENZA_TASSOMICA")
	@GraphQLQuery(name="referenzaTassomica")
	public Integer getReferenzaTassonomica() {
		return referenzaTassonomica;
	}
	public void setReferenzaTassonomica(Integer referenzaTassonomica) {
		this.referenzaTassonomica = referenzaTassonomica;
	}
	
	@Column(name="NON_TAXON")
	@GraphQLQuery(name="nonTaxon")
	public String getNonTaxon() {
		return nonTaxon;
	}
	public void setNonTaxon(String nonTaxon) {
		this.nonTaxon = nonTaxon;
	}
	
	@Column(name="TAXON_BUONO")
	@GraphQLQuery(name="taxonBuono")
	public String getTaxonBuono() {
		return taxonBuono;
	}
	public void setTaxonBuono(String taxonBuono) {
		this.taxonBuono = taxonBuono;
	}
	
	@Column(name="DENOMINAZIONE_TAXON_BUONO")
	@GraphQLQuery(name="denominazioneTaxonBuono")
	public String getDenominazioneTaxonBuono() {
		return denominazioneTaxonBuono;
	}
	public void setDenominazioneTaxonBuono(String denominazioneTaxonBuono) {
		this.denominazioneTaxonBuono = denominazioneTaxonBuono;
	}
	
	@Column(name="SINONIMO_ACCETTATO")
	@GraphQLQuery(name="sinonimoAccettato")
	public String getSinonimoAccettato() {
		return sinonimoAccettato;
	}
	public void setSinonimoAccettato(String sinonimoAccettato) {
		this.sinonimoAccettato = sinonimoAccettato;
	}
	
	@Column(name="NOTE")
	@GraphQLQuery(name="note")
	public String getNote() {
		return note;
	}
	public void setNote(String note) {
		this.note = note;
	}
	
	@Transient
	@GraphQLQuery(name="nomeMenu")
	public String getNomeMenu() {
		return (nomeItaliano!=null? nomeItaliano+" ("+denominazioneTaxon+")":denominazioneTaxon);
	}
	public void setNomeMenu(String nomeMenu) {
		this.nomeMenu = nomeMenu;
	}

	
	
}
